import java.io.*;

class ProThread extends Thread {
	private final PipedOutputStream pipedOutStream;
	private final int[] produkte = {1, 2, 3};
	private final Thread konsument;

	ProThread(PipedOutputStream pos, Thread kon) {
		pipedOutStream = pos;
		konsument = kon;
	}

	@Override
	public void run() {
		try (pipedOutStream) {
			for (int i = 0; i < produkte.length; i++) {
				System.out.println("\nDer Produzent liefert gleich.");
				pipedOutStream.write(produkte[i]);
				pipedOutStream.flush();
				sleep(500);
				System.out.println("Kurz nach der Lieferung ist der Konsument " + konsument.getState());
				sleep(5000);
				System.out.println("Produzent wacht auf, Konsument ist " + konsument.getState());
			}
		} catch (InterruptedException ie) {	// Ignorieren ist OK, weil kein Interrupt signalisiert wird.
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
}